/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.chatlet.ChatletClient;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientManager;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletErrorResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletException;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletInitialRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletTerminateRequest;
import com.ibm.hwmca.fw.util.Trace;

public final class ChatletClientPortal {
    private static final String TRACE_MASKF = "XFCS-CPF";
    private static int theChatletId = 0;
    private ChatletClientManager manager;
    private ChatletClient chatletClient;
    private int chatletId = 0;
    private boolean terminate = false;

    private static synchronized int getNextChatletId() {
        return theChatletId++;
    }

    ChatletClientPortal(ChatletClientManager manager, ChatletClient chatletClient) {
        this.manager = manager;
        this.chatletClient = chatletClient;
        this.chatletId = ChatletClientPortal.getNextChatletId();
    }

    public ChatletResponse sendRequest(ChatletRequest chatletRequest) throws ChatletException {
        Trace.trace(TRACE_MASKF, "-> sendRequest(" + chatletRequest + ")");
        ChatletResponse response = this.sendRequest(chatletRequest, -1);
        Trace.trace(TRACE_MASKF, "<- sendRequest(" + chatletRequest + ")");
        return response;
    }

    public ChatletResponse sendRequest(ChatletRequest chatletRequest, int timeout) throws ChatletException {
        Trace.trace(TRACE_MASKF, "-> sendRequest(" + chatletRequest + ", " + timeout + ")");
        chatletRequest.setChatletId(this.chatletId);
        ChatletResponse response = this.manager.sendRequest(chatletRequest, timeout);
        Trace.trace(TRACE_MASKF, "<- sendRequest(" + chatletRequest + ", " + timeout + ")");
        return response;
    }

    public ChatletClientManager getManager() {
        return this.manager;
    }

    void terminate() throws ChatletException {
        if (!this.terminate) {
            this.terminate = true;
            try {
                this.chatletClient.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sendRequest(new ChatletTerminateRequest());
        }
    }

    void flowInitialRequest() throws ChatletException {
        Trace.trace(TRACE_MASKF, "-> flowInitialRequest()");
        ChatletResponse response = this.sendRequest(new ChatletInitialRequest(this.chatletClient.getRemoteChatletClass()));
        if (response instanceof ChatletErrorResponse) {
            throw new ChatletException("An error occured setting up the remote Chatlet, cause:" + response);
        }
        Trace.trace(TRACE_MASKF, "<- flowInitialRequest()");
    }

    int getChatletId() {
        return this.chatletId;
    }
}

